library('deSolve')

# derivative function for carbon-flux model
dC_dt = function(t,C,parms)
  {
  return(list(parms$M%*%C))
  }

# transition matrix
M = matrix(c(-10  ,  0    ,  0     ,  0     ,
               0  , -0.3  ,  0     ,  0     ,
               1  ,  0.03 , -0.594 ,  0.0020,
               1.2,  0.036,  0.0792, -0.0176),4,4,byrow=T)

# use ode() to integrate the model
parms = list(M=M)
C0 = c(10,30,100,100)
ts = seq(0,10,length.out=100)
C_t = ode(C0,ts,dC_dt,parms=parms)

par(mfrow=c(2,2))
for ( i in 1:4 )
  {
  plot(ts,C_t[,i+1],type='l',ylab=paste0('C[',i,']'))
  } 
